import axios from 'axios';
import { notify } from './helper';

const API_BASE_URL = process.env.NEXT_PUBLIC_SERVER_BASE_URL;
// const API_BASE_URL = 'https://server.tnmmediaacademy.edu.ng/api/v3/admin';
// const API_BASE_URL = 'http://localhost:7010/api/v3/admin';
// const API_BASE_URL = 'http://localhost:7010/api/v4/admin';

const api = axios.create({
    baseURL: API_BASE_URL,
});

export const login = async (data) => {
    try {
        console.log(`${API_BASE_URL}/login`);
        const response = await api({
            method: 'post',
            url: `/login`,
            data,
        });

        return response.data
    } catch (error) {
        console.log(error)
        if (error.response?.data) {
            notify('error', error.response.data.message)
        } else {
            notify('error', error.message);
        }
    }
}

export const getDashboardData = async (token) => {
    try {
        const response = await api({
            method: 'get',
            url: `/dashboard`,
            headers: {
                Authorization: `Bearer ${token}`
            }
        });

        return response.data;
    } catch (error) {
        console.log(error)
    }
}

export const getProgrammes = async (token) => {
    try {
        const response = await api({
            method: 'get',
            url: `/programmes`,
            headers: {
                Authorization: `Bearer ${token}`
            }
        });

        return response.data;
    } catch (error) {
        console.log(error)
        // if (error.response?.data) {
        //     notify('error', error.response.data.message)
        // } else {
        //     notify('error', error.message);
        // }
    }
}

export const getAcademicSessions = async (token) => {
    try {
        const respnse = await api({
            method: 'get',
            url: `/sessions`,
            headers: {
                Authorization: `Bearer ${token}`
            }
        })

        return respnse.data;
    } catch (error) {
        console.log(error);
        // throw error;
    }
}

export const getAdmins = async (token) => {
    try {
        const response = await api({
            method: 'get',
            url: `/`,
            headers: {
                Authorization: `Bearer ${token}`
            }
        });

        return response.data;
    } catch (error) {
        console.log(error);
    }
}

export const getRoles = async (token) => {
    try {
        const response = await api({
            method: 'get',
            url: `/roles`,
            headers: {
                Authorization: `Bearer ${token}`
            }
        });

        return response.data;
    } catch (error) {
        console.log(error);
    }
}

export const getMe = async (token) => {
    try {
        const response = await api({
            method: 'get',
            url: `/me`,
            headers: {
                Authorization: `Bearer ${token}`
            }
        });

        return response.data;
    } catch (error) {
        if(error.response) {
            console.log(error.response.data.errors)
        }
        console.log(error);
    }
}

export const createAdmin = async (token, data) => {
    try {
        const response = await api({
            method: 'post',
            url: `/`,
            data,
            headers: {
                Authorization: `Bearer ${token}`
            }
        });

        return response.data;
    } catch (error) {
        console.log(error);
    }
}

export const editAdmin = async (token, data) => {
    try {
        const response = await api({
            method: 'patch',
            url: `/${data.id}`,
            data,
            headers: {
                "Content-Type": "application/json",
                Authorization: `Bearer ${token}`
            }
        });

        return response.data;
    } catch (error) {
        console.log(error);
    }
}

export const getCourses = async (token, stream) => {
    try {
        const response = await api({
            method: 'get',
            url: `/courses/${stream}`,
            headers: {
                Authorization: `Bearer ${token}`
            }
        });

        return response.data;
    } catch (error) {
        console.log(error.message)
        // if (error.response?.data) {
        //     notify('error', error.response.data.message)
        // } else {
        //     notify('error', error.message);
        // }
    }
}

export const getACourse = async (token, stream, id) => {
    try {
        const response = await api({
            method: 'get',
            url: `/courses/${stream}/${id}`,
            headers: {
                Authorization: `Bearer ${token}`
            }
        });

        return response.data;
    } catch (error) {
        console.log(error.message)
        // if (error.response?.data) {
        //     notify('error', error.response.data.message)
        // } else {
        //     notify('error', error.message);
        // }
    }
}

export const getAssignedCourses = async (token, stream) => {
    try {
        const response = await api({
            method: 'get',
            url: `/courses/${stream}/stf/assigned`,
            headers: {
                Authorization: `Bearer ${token}`
            }
        });

        return response.data;
    } catch (error) {
        if(error.response) {
            console.log(error.response.data.errors)
        }
        console.log(error);
    }
}

export const assignStaff = async (token, stream, id, data) => {
    try {
        const response = await api({
            method: 'post',
            url: `courses/${stream}/${id}/assign`,
            data,
            headers: {
                Authorization: `Bearer ${token}`
            }
        })

        return response.data;
    } catch (error) {
        console.log(error);
        if (error.response?.data) {
            notify('error', error.response.data.message)
        } else {
            notify('error', error.message);
        }
    }
}

export const getAssignedStaff = async (token, stream, id) => {
    try {
        const response = await api({
            method: 'get',
            url: `courses/${stream}/${id}/assign`,
            headers: {
                Authorization: `Bearer ${token}`
            }
        });

        return response.data;
    } catch (error) {
        console.log(error);
    }
}

export const getStudents = async (token) => {
    try {
        const response = await api({
            method: 'get',
            url: `/students`,
            headers: {
                Authorization: `Bearer ${token}`
            }
        });

        return response.data;
    } catch (error) {
        console.log(error);
    }
}

export const getApplicants = async (token, stream) => {
    try {
        const response = await api({
            method: 'get',
            url: `/aspirants/${stream}/applications`,
            headers: {
                Authorization: `Bearer ${token}`
            }
        });

        return response.data;
    } catch (error) {
        if(error.response) {
            // console.group(error.response.data.errors)
            console.log(error.response.data.errors)
        } else {
            console.log(error.response);
        }
    }
}

export const getApplication = async (token, stream, id) => {
    try {
        const response = await api({
            method: 'get',
            url: `/aspirants/${stream}/applications/${id}`,
            headers: {
                Authorization: `Bearer ${token}`
            }
        });

        return response.data;
    } catch (error) {
        console.log(error.response);
    }
}

export const reviewApplication = async (token, stream, id, data) => {
    try {
        console.log(stream, id)
        const response = await api({
            method: 'patch',
            url: `/aspirants/${stream}/applications/${id}`,
            data,
            headers: {
                Authorization: `Bearer ${token}`
            }
        });

        return response.data;
    } catch (error) {
        console.log(error)
    }
}

export const getCourseResult = async (token, id, session_id) => {
    try {
        const response = await api({
            method: 'get',
            url: `/result/course/${id}/${session_id}`,
            headers: {
                Authorization: `Bearer ${token}`
            }
        })

        return response.data;
    } catch (error) {
        console.log(error)
    }
}

export const uploadResult = async (token, stream, data) => {
    try {
        const response = await api({
            method: 'post',
            url: `/result/${stream}`,
            data,
            headers: {
                Authorization: `Bearer ${token}`
            }
        })

        return response.data;
    } catch (error) {
        console.log(error);
    }
}

export const download = async (token, file_path) => {
    try {
        const response = await api({
            method: 'get',
            url: `/download/${file_path}`,
            headers: {
                Authorization: `Bearer ${token}`,   
            },
            responseType: 'blob',
        });

        return response.data;
    } catch (error) {
        console.log(error)
        throw error;
    }
}