import { cookies } from "next/headers";
import { isTokenExpired } from "../utils/helper";
import { NextResponse } from "next/server";

export function authMiddleware(middleware) {
    return async (request, event) => {
        const sigin = request.nextUrl.pathname.startsWith('/auth')
        console.log(sigin, '<= pathname');

        if(sigin) return middleware(request, event)

        const expired = isTokenExpired(cookies().get('admin')?.value)
        if (expired) {
            console.log('token expired');
            return NextResponse.redirect(new URL('/auth/signin', request.url));
        
        }
        return middleware(request, event)
    }
}