import { useState } from "react"
import cookies from 'js-cookie'
import { uploadResult } from "../utils/app";
import { notify } from "../utils/helper";


const UploadResultForm = ({ hideModal, sessions, stream, course_id }) => {
    const [formData, setFormData] = useState({
        session_id: '',
        level: '',
        sheetName: '',
        result: ''
    })

    const handleChange = (event) => {
        const { name, value } = event.target;

        setFormData(prev => ({
            ...prev,
            [name]: value
        }))
    };
console.log(formData, course_id);
    const handleSubmit = async (e) => {
        e.preventDefault();
        try {
            const data = new FormData();
            data.append('session_id', formData.session_id);
            data.append('level', formData.level);
            data.append('sheetName', formData.sheetName);
            data.append('result', formData.result);
            data.append('course_id', course_id);
            const token = cookies.get('admin');
            const res = await uploadResult(token, stream, data);

            if (!res) throw new Error('Failed to upload');
            notify('success', 'Successfully uploaded');
            // hideModal();
        } catch (error) {
            const errorMessage = error.response?.data?.message || error.message || String(error);
            notify('error', errorMessage);
        }
    }

    return (
        <div>
            <div id="editUserModal" className="fixed inset-0 z-50 flex items-center justify-center w-full p-4 overflow-x-hidden overflow-y-auto max-h-full bg-black bg-opacity-50">
                <div className="relative w-full max-w-2xl">
                    <form onSubmit={handleSubmit} className="relative bg-white rounded-lg shadow dark:bg-gray-700">
                        <div className="flex items-start justify-between p-4 border-b rounded-t dark:border-gray-600">
                            <h3 className="text-xl font-semibold text-gray-900 dark:text-white">Result</h3>
                            <button type="button" onClick={() => hideModal()} className="text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm p-2 dark:hover:bg-gray-600 dark:hover:text-white">
                                <svg className="w-3 h-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 14 14">
                                    <path stroke="currentColor" strokeLinecap="round" strokeLinejoin="round" strokeWidth="2" d="M1 1l6 6m0 0l6 6M7 7l6-6M7 7L1 13" />
                                </svg>
                                <span className="sr-only">Close modal</span>
                            </button>
                        </div>
                        <div className="p-6 space-y-6">
                            <div className="grid grid-cols-6 gap-6">
                                <div className="col-span-6 sm:col-span-3">
                                    <label htmlFor="session_id" className="block mb-2 text-sm font-medium text-gray-900 dark:text-white">Session</label>
                                    <select
                                        id="session_id"
                                        name="session_id"
                                        value={formData.session_id}
                                        onChange={handleChange}
                                        className="shadow-sm bg-orange-50 border border-orange-300 text-gray-900 text-sm rounded-lg focus:ring-orange-600 focus:border-orange-600 block w-full"
                                        required
                                    >
                                        <option>Select Session</option>
                                        {sessions.map(session => (
                                            <option key={session.id} value={session.id}>{session.name}</option>
                                        ))}
                                    </select>
                                </div>
                                <div className="col-span-6 sm:col-span-3">
                                    <label htmlFor="level" className="block mb-2 text-sm font-medium text-gray-900 dark:text-white">Level</label>
                                    <select name="level" id="level" value={formData.level} className='shadow-sm bg-orange-50 border border-orange-300 text-gray-900 text-sm rounded-lg focus:ring-orange-600 focus:border-orange-600 block w-full' onChange={handleChange} required>
                                        <option>Level</option>
                                        <option value={100}>NID 1</option>
                                        <option value={200}>NID 2</option>
                                    </select>
                                </div>
                                <div className="col-span-6 sm:col-span-3">
                                    <label htmlFor="sheetName" className="block mb-2 text-sm font-medium text-gray-900 dark:text-white">Sheet Name</label>
                                    <input type="text" name="sheetName" id="sheetName" className="shadow-sm bg-orange-50 border border-orange-300 text-gray-900 text-sm rounded-lg focus:ring-orange-600 focus:border-orange-600 block w-full" onChange={handleChange} required />
                                </div>
                                <div className="col-span-6 sm:col-span-3">
                                    <label htmlFor="file" className="block mb-2 text-sm font-medium text-gray-900 dark:text-white">File</label>
                                    <input type="file" name="file" id="file" className="shadow-sm bg-orange-50 border border-orange-300 text-gray-900 text-sm rounded-lg focus:ring-orange-600 focus:border-orange-600 block w-full" onChange={(e) => setFormData(prev => ({...prev, result: e.target.files[0]}))} required />
                                </div>
                            </div>
                        </div>
                        <div className="flex items-center p-6 space-x-2 border-t border-gray-200 rounded-b dark:border-gray-600">
                            <button type="submit" className="bg-orange-700 text-white hover:bg-orange-800 focus:ring-4 focus:outline-none focus:ring-orange-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center">Upload</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    )
}

export default UploadResultForm