import { useEffect, useRef, useState } from 'react'
import { IoMdClose } from 'react-icons/io'
import { getProgrammes } from '../utils/app';
import cookies from 'js-cookie';

const RecommendationForm = ({ onClose }) => {
    const [programmes, setProgrammes] = useState([]);
    const formRef = useRef()

    useEffect(() => {
        const fetchProgrammes = async () => {
            const programmes = await getProgrammes(cookies.get('admin'));

            if (!programmes) return;

            setProgrammes(programmes.data);
        }

        fetchProgrammes();
    }, []);


    return (
        <div>
            <div className="fixed inset-0 flex items-center justify-center z-50 w-screen p-5 fade-in-regular">
                <div className="fixed inset-0 bg-black opacity-30"></div>
                <div className="relative h-80 w-full max-w-5xl p-3 overflow-hidden bg-white rounded-lg md:p-10">
                    <div className='flex justify-between mb-5'>
                        <h2 className="text-black text-2xl font-bold text-center">Recommend</h2>
                        <div className="flex justify-end w-full">
                            <IoMdClose
                                className="mb-3 text-xl transition duration-300 ease-in-out cursor-pointer md:text-3xl md:mb-0 text-slate-800 hover:text-red-600"
                                onClick={onClose}
                            />
                        </div>

                    </div>
                    <form ref={formRef}>
                        <div className="flex flex-col gap-5">
                            <select className="bg-orange-500 text-white placeholder:text-white outline-none rounded-lg h-12 p-2 w-full" name="session_id">
                                <option>programme</option>
                                {programmes.map((prog, i) => (
                                    <option key={i} value={prog.id}>{prog.name} - {prog.stream}</option>
                                ))}
                            </select>
                            <textarea placeholder='Comment' className='rounded-lg'></textarea>
                        </div>

                        <button className="text-white bg-orange-700 w-32 h-10 rounded-md absolute bottom-5 right-10 mt-5" disabled>Done</button>
                    </form>
                </div>
            </div>
        </div>
    )
}

export default RecommendationForm