'use client'

import { useState } from 'react';
import { notify } from '../utils/helper';
import { createAdmin } from '../utils/app';
import cookies from 'js-cookie';

const CreateAdminForm = ({ roles }) => {
    const [formData, setFormData] = useState({
        name: "",
        email: "",
        role_id: "",
        password: ''
    });

    const handleChange = (field, value) => {
        console.log('dere')
        setFormData(prev => ({ ...prev, [field]: value }));
    };

    const handleChangeV2 = (event) => {
        const { name, value } = event.target;
        setFormData(prev => ({
            ...prev,
            [name]: value
        }))
    }

    console.log(formData)

    const handleSubmit = async (event) => {
        event.preventDefault();
        if (!formData.email || !formData.role_id || !formData.name || !formData.password) {
            notify('error', 'Please fill in all fields');
            return;
        }

        try {

            const response = await createAdmin(cookies.get('admin'), formData);

            if (!response) throw new Error('Network response was not ok');

            notify('success', 'Admin created successfully');

            setFormData({ name: "", email: "", role_id: "", password: "" });
        } catch (err) {
            notify('error', `Error adding admin: ${err.message}`);
        }
    };

    return (
        <form onSubmit={handleSubmit} className="mb-6">
            <div className="grid lg:grid-cols-4 gap-4 mb-4">
                <input
                    type="text"
                    name='name'
                    value={formData.name}
                    onChange={handleChangeV2}
                    placeholder="Name"
                    className="border p-2 rounded"
                />
                <input
                    type="email"
                    name='email'
                    value={formData.email}
                    onChange={handleChangeV2}
                    placeholder="Email"
                    className="border p-2 rounded"
                />
                <input
                    type="password"
                    name='password'
                    value={formData.password}
                    onChange={handleChangeV2}
                    placeholder="Password"
                    className="border p-2 rounded"
                />
                <select
                    name='role_id'
                    value={formData.role_id}
                    onChange={handleChangeV2}
                    className="border p-2 rounded"
                >
                    <option value="">Select Role</option>
                    {roles.map(role => (
                        <option key={role.id} value={role.id}>{role.title}</option>
                    ))}
                </select>
            </div>
            <button type="submit" className="bg-blue-500 text-white px-6 py-2 rounded hover:bg-blue-600">
                Create
            </button>
        </form>
    );
};

export default CreateAdminForm;
