import Image from 'next/image'
import logo from '@/app/img/logo.png'
import AccountSection from './AccountSection';
import { getMe } from '../utils/app';
import { cookies } from 'next/headers';
// import { isTokenExpired } from '../utils/helper';
// import { redirect } from 'next/navigation';

const fetchProfile = async () => {
  const me = await getMe(cookies().get('admin')?.value);

  return me?.data;
}

const NavBar = async () => {
  // const expired = isTokenExpired(cookies().get('admin').value)
  // if (expired) {
  //   console.log('token expired');
  //   redirect('/auth/signin');
  // }

  // const me = await fetchProfile(); 

  return (
    <nav className="fixed top-0 z-50 w-full bg-white border-b border-orange-200 dark:bg-gray-800 dark:border-gray-700">
      <div className="px-3 py-3 lg:px-5 lg:pl-3">
        <div className="flex items-center justify-between">
          <div className="flex items-center justify-start rtl:justify-end">
            {/* <Image src={logo} width={100} height={100} className="h-8 me-3" alt="TNM Logo" /> */}
            <Image src={logo} alt='TNM Logo' className='p-2 w-20 h-16' />
          </div>
          <AccountSection />
        </div>
      </div>
    </nav>
  ); 
}

export default NavBar