'use client'

import { useState } from "react";

const DropDownMenu = ({ icon, name, list }) => {
  const [show, setShow] = useState(false);

  return (
    <div>
      <button type="button" className="flex items-center w-full p-2 text-base font-normal text-gray-900 transition duration-75 rounded-lg group hover:bg-gray-100 dark:text-white dark:hover:bg-gray-700" onClick={() => setShow(!show)}>
        {icon}
        <span className="flex-1 ml-3 text-left whitespace-nowrap" sidebar-toggle-item='true'>{name}</span>
        <svg sidebar-toggle-item='true' className="w-6 h-6" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg"><path fillRule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clipRule="evenodd"></path></svg>
      </button>
      {show && (
        <ul className="py-2 space-y-2 list-disc">
          {list.map((lst, index) => (
            <li key={index}>
            <a href={lst.link}
              className="flex items-center w-full p-2 text-base font-normal text-gray-900 transition duration-75 rounded-lg group hover:bg-gray-100 dark:text-white dark:hover:bg-gray-700 pl-11">{lst.name}</a>
          </li>
          ))}
        </ul>
      )}
    </div>
  )
}

export default DropDownMenu