'use client'
import Image from 'next/image';
import { useState } from 'react'
import cookies from 'js-cookie';
import { useRouter } from 'next/navigation';
import avatar from '@/app/img/avatar1.webp'
import Hamburger from './Hamburger';

const AccountSection = () => {
    const [isDropdownOpen, setIsDropdownOpen] = useState(false);
    const [isHovering, setIsHovering] = useState(false);
    const roouter = useRouter();

    const logout = () => {
        cookies.remove('student');
        roouter.replace('/auth/signin');
    }

    return (
        <div>
            <div className="flex items-center gap-2">
                <div className="hidden sm:block relative"
                    onMouseEnter={() => setIsHovering(true)}
                    onMouseLeave={() => setIsHovering(false)}>
                    {/* Session and semester details */}
                    <div className="flex flex-col text-sm text-gray-800 dark:text-gray-200 cursor-pointer">
                        <span>2023/2024</span>
                        <span>First Semester</span>
                    </div>
                    {/* Buttons appear on hover over session and semester details */}
                    {isHovering && (
                        <div className="absolute flex flex-col items-start mt-2">
                            <button className="px-4 py-2 bg-blue-500 text-white rounded hover:bg-blue-600">Reset</button>
                            <button className="px-4 py-2 mt-1 bg-green-500 text-white rounded hover:bg-green-600">Add</button>
                        </div>
                    )}
                </div>
                <Hamburger />
                {/* User dropdown menu */}
                <div className="ml-4 relative">
                    <button onClick={() => setIsDropdownOpen(!isDropdownOpen)} className="flex text-sm bg-gray-800 rounded-full focus:ring-4 focus:ring-gray-300 dark:focus:ring-gray-600" aria-expanded="false">
                        <span className="sr-only">Open user menu</span>
                        <Image className="w-10 h-10 rounded-full" src={avatar} alt="student pic" />
                    </button>
                    {isDropdownOpen && (
                        <div className="absolute right-0 w-48 py-1 mt-2 bg-white rounded-md shadow-lg dark:bg-gray-700">
                            <a href="#" className="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100 dark:text-gray-300 dark:hover:bg-gray-600">Dashboard</a>
                            <a href="#" className="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100 dark:text-gray-300 dark:hover:bg-gray-600">Settings</a>
                            <div onClick={logout} className="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100 dark:text-gray-300 dark:hover:bg-gray-600 cursor">Sign out</div>
                        </div>
                    )}
                </div>
            </div>
        </div>
    )
}

export default AccountSection