import { getStudents } from "@/app/utils/app";
import StudentTable from "../component/StudentTable";
import { cookies } from "next/headers";

const fetchStudents = async () => {
  const students = await getStudents(cookies().get('admin').value);

  return students.data
}

const page = async () => {
  const students = await fetchStudents();

  return (
    <div>
        <h1 className="mb-8">Students</h1>
        <StudentTable students={students} />
    </div>
  )
}

export default page