'use client'

import Cookies from 'js-cookie';
import { useState } from 'react'

const RoleTable = ({roles}) => {
    const [editIndex, setEditIndex] = useState(null);
    const [editFormData, setEditFormData] = useState({ title: '', description: '', permissions: '' });

    console.log(roles)

    const handleEdit = (index, admin) => {
        setEditIndex(index);
        // setEditFormData(prev => ({...prev, id}));
        setEditFormData(admin);
    };

    console.log(editFormData)

    const handleSave = async (index) => {
        try {
            // const response = await editAdmin(Cookies.get('admin'), editFormData);

            // if (!response) throw new Error('Network response was not ok');

            setEditIndex(null);
        } catch (err) {
            notify('error', `Failed to update admin: ${err.message}`);
        }
    };

    const handleChange = (field, value) => {
        setEditFormData(prev => ({ ...prev, [field]: value }));
    };

    return (
        <div className="overflow-x-auto">
            <table className="w-full">
                <thead className="bg-gray-100">
                    <tr>
                        <th className="text-left p-4">Title</th>
                        <th className="text-left p-4">Permissions</th>
                        <th className="text-left p-4">Description</th>
                        <th className="text-left p-4">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    {roles?.map((admin, index) => (
                        index === editIndex ? (
                            <tr key={admin.id} className="border-t">
                                <td className="p-4">
                                    <input
                                        type="text"
                                        value={editFormData.title}
                                        onChange={(e) => handleChange('title', e.target.value)}
                                        className="border p-2 rounded"
                                    />
                                </td>
                                <td className="p-4">
                                    <input
                                        type="permissions"
                                        value={editFormData.permissions}
                                        onChange={(e) => handleChange('permissions', e.target.value)}
                                        className="border p-2 rounded"
                                    />
                                </td>
                                <td className="p-4">
                                    <select
                                        value={editFormData.description}
                                        onChange={(e) => handleChange('description', e.target.value)}
                                        className="border p-2 rounded"
                                    >
                                        <option value={editFormData.role}>{editFormData.role}</option>
                                        {roles.map(role => (
                                            <option key={role.id} value={role.id}>{role.title}</option>
                                        ))}
                                    </select>
                                </td>
                                <td className="p-4">
                                    <button onClick={() => handleSave(index)} className="bg-green-500 text-white px-4 py-1 rounded hover:bg-green-600">Save</button>
                                </td>
                            </tr>
                        ) : (
                            <tr key={admin.id} className="border-t">
                                <td className="p-4">{admin.title}</td>
                                <td className="p-4">{admin.permissions}</td>
                                <td className="p-4">{admin.role}</td>
                                <td className="p-4">
                                    <button onClick={() => handleEdit(index, admin)} className="bg-blue-500 text-white px-4 py-1 rounded hover:bg-blue-600">Edit</button>
                                </td>
                            </tr>
                        )
                    ))}
                </tbody>
            </table>
        </div>
    );
}

export default RoleTable