'use client'

import { editAdmin } from '@/app/utils/app';
import { useState } from 'react';
import cookies from 'js-cookie';
import { notify } from '@/app/utils/helper';

const AdminTable = ({ admins, onAdminUpdate, roles }) => {
    const [editIndex, setEditIndex] = useState(null);
    const [editFormData, setEditFormData] = useState({ name: '', email: '', role_id: '' });

    const handleEdit = (index, admin) => {
        setEditIndex(index);
        // setEditFormData(prev => ({...prev, id}));
        setEditFormData(admin);
    };

    const handleSave = async (index) => {
        try {
            const response = await editAdmin(cookies.get('admin'), editFormData);

            if (!response) throw new Error('Network response was not ok');

            // onAdminUpdate(index, editFormData);
            setEditIndex(null);
        } catch (err) {
            notify('error', `Failed to update admin: ${err.message}`);
        }
    };

    const handleChange = (field, value) => {
        setEditFormData(prev => ({ ...prev, [field]: value }));
    };

    return (
        <div className="overflow-x-auto">
            <table className="w-full">
                <thead className="bg-gray-100">
                    <tr>
                        <th className="text-left p-4">Name</th>
                        <th className="text-left p-4">Email</th>
                        <th className="text-left p-4">Role</th>
                        <th className="text-left p-4">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    {admins?.map((admin, index) => (
                        index === editIndex ? (
                            <tr key={admin.id} className="border-t">
                                <td className="p-4">
                                    <input
                                        type="text"
                                        value={editFormData.name}
                                        onChange={(e) => handleChange('name', e.target.value)}
                                        className="border p-2 rounded"
                                    />
                                </td>
                                <td className="p-4">
                                    <input
                                        type="email"
                                        value={editFormData.email}
                                        onChange={(e) => handleChange('email', e.target.value)}
                                        className="border p-2 rounded"
                                    />
                                </td>
                                <td className="p-4">
                                    <select
                                        value={editFormData.role_id}
                                        onChange={(e) => handleChange('role_id', e.target.value)}
                                        className="border p-2 rounded"
                                    >
                                        <option value={editFormData.role_id}>{editFormData.role_id}</option>
                                        {roles.map(role => (
                                            <option key={role.id} value={role.id}>{role.title}</option>
                                        ))}
                                    </select>
                                </td>
                                <td className="p-4">
                                    <button onClick={() => handleSave(index)} className="bg-green-500 text-white px-4 py-1 rounded hover:bg-green-600">Save</button>
                                </td>
                            </tr>
                        ) : (
                            <tr key={admin.id} className="border-t">
                                <td className="p-4">{admin.name}</td>
                                <td className="p-4">{admin.email}</td>
                                <td className="p-4">{admin.role}</td>
                                <td className="p-4">
                                    <button onClick={() => handleEdit(index, admin)} className="bg-blue-500 text-white px-4 py-1 rounded hover:bg-blue-600">Edit</button>
                                </td>
                            </tr>
                        )
                    ))}
                </tbody>
            </table>
        </div>
    );
};

export default AdminTable;
