import AdminTable from '../component/AdminTable'
import CreateAdminForm from '@/app/forms/CreateAdminForm'
import { getAdmins, getRoles } from '@/app/utils/app';
import { cookies } from 'next/headers';

export const dynamic = 'force-dynamic';

const fetchAdmins = async () => {
    const admins = await getAdmins(cookies().get('admin').value);

    return admins?.data;
}

const fetchRoles = async () => {
    const roles = await getRoles(cookies().get('admin').value)

    return roles.data
}

const page = async () => {
    const admins = await fetchAdmins();
    const roles = await fetchRoles()

    return (
        <div className='text-black'>
            <CreateAdminForm roles={roles}  />
            <AdminTable admins={admins} roles={roles} />
        </div>
    );
};

export default page;
