import { getDashboardData } from "@/app/utils/app"
import { cookies } from "next/headers"

const fetchDashboardData = async () => {
    const data = await getDashboardData(cookies().get('admin').value);

    return data.data
}
const page = async () => {
    const { courses_count, student_count, aspirants_count, professional_aspirants, total_sessions, total_diet } = await fetchDashboardData();

    return (
        <div className="">
            <div className="grid grid-cols-2 sm:grid-cols-3 gap-4 mb-4">
                <div className="flex items-center justify-center h-24 rounded bg-gray-50 dark:bg-gray-800 border-b-4 border-orange-400 border-solid">
                    <p className="text-2xl text-gray-400 dark:text-gray-500">
                        {courses_count} Courses
                    </p>
                </div>
                <div className="flex items-center justify-center h-24 rounded bg-gray-50 dark:bg-gray-800 border-b-4 border-orange-400 border-solid">
                    <p className="text-2xl text-gray-400 dark:text-gray-500">
                        {student_count} Students
                    </p>
                </div>
                <div className="flex items-center justify-center h-24 rounded bg-gray-50 dark:bg-gray-800 border-b-4 border-orange-400 border-solid">
                    <p className="text-2xl text-gray-400 dark:text-gray-500">
                        { } Staffs
                    </p>
                </div>
                <div className="flex items-center justify-center h-24 rounded bg-gray-50 dark:bg-gray-800 border-b-4 border-orange-400 border-solid">
                    <div className="text-2xl text-gray-400 dark:text-gray-500">
                        {aspirants_count + professional_aspirants} Applications
                            <ul className="list-none pl-5 mt-1 text-xs">
                                <li>NID: {aspirants_count}</li>
                                <li>Professional: {professional_aspirants}</li>
                            </ul>
                    </div>
                </div>

                <div className="flex items-center justify-center h-24 rounded bg-gray-50 dark:bg-gray-800 border-b-4 border-orange-400 border-solid">
                    <p className="text-2xl text-gray-400 dark:text-gray-500">
                        {total_sessions} { total_sessions < 1 ? 'session' : 'sessions'}
                    </p>
                </div>
                <div className="flex items-center justify-center h-24 rounded bg-gray-50 dark:bg-gray-800 border-b-4 border-orange-400 border-solid">
                    <p className="text-2xl text-gray-400 dark:text-gray-500">
                        {total_diet} Diets
                    </p>
                </div>
            </div>
        </div>
    )
}

export default page