'use client'

import { getAcademicSessions, getCourseResult } from "@/app/utils/app";
import { useEffect, useState } from "react";
import cookies from 'js-cookie';
import UploadResultForm from "@/app/forms/UploadResultForm";

const Result = ({ course_id, stream }) => {
    const [sessions, setSessions] = useState([]);
    const [sessionId, setSessionId] = useState('');
    const [result, setResult] = useState(null);
    const [showModal, setShowModal] = useState(false);

    useEffect(() => {
        const fetchSessions = async () => {
            const sessions = await getAcademicSessions(cookies.get('admin'));

            setSessions(sessions.data)
        }

        fetchSessions();
    }, []);

    const hideModal = () => setShowModal(!showModal);

    const fetchResult = async (e) => {
        // setSessionId(e.target.value);

        // console.log(sessionId)
        if (e.target.value) {
            const response = await getCourseResult(cookies.get('admin'), course_id, e.target.value);

            console.log(response.data);

            setResult(response.data)
        }
    }

    return (
        <div>
            <div className="flex justify-between items-center">
                <div className="w-64">
                    <label htmlFor="sessionId" className="block text-sm font-medium text-gray-700">Session</label>
                    <select
                        id="sessionId"
                        name="sessionId"
                        value={sessionId}
                        onChange={fetchResult}
                        className="mt-1 block w-full py-2 px-3 border border-gray-300 bg-white rounded-md shadow-sm focus:outline-none focus:ring-orange-500 focus:border-orange-500 sm:text-sm"
                    >
                        <option value="">Select Session</option>
                        {sessions.map(session => (
                            <option key={session.id} value={session.id}>{session.name}</option>
                        ))}
                    </select>
                </div>
                <div>
                    <button className="bg-orange-500 p-2 rounded-lg text-orange-200" onClick={() => setShowModal(true)}>Upload</button>
                </div>
            </div>

            {result && (
                <div className="relative overflow-x-auto shadow-md sm:rounded-lg mt-8">
                    <table className="w-full text-sm text-left rtl:text-right text-gray-500 dark:text-gray-400">
                        <thead className="text-xs text-gray-700 uppercase bg-gray-50 dark:bg-gray-700 dark:text-gray-400">
                            <tr>
                                <th scope="col" className="px-6 py-3">
                                    Admission Number
                                </th>
                                <th scope="col" className="px-6 py-3">
                                    CA
                                </th>
                                <th scope="col" className="px-6 py-3">
                                    Exam
                                </th>
                                <th scope="col" className="px-6 py-3">
                                    Total
                                </th>
                                <th scope="col" className="px-6 py-3">
                                    Weight
                                </th>
                            </tr>
                        </thead>
                        <tbody>
                            {result?.map(student => {
                                return (
                                    <tr key={student.id} className="bg-white border-b dark:bg-gray-800 dark:border-gray-700 hover:bg-gray-50 dark:hover:bg-gray-600">
                                        <th scope="row" className="px-6 py-4 font-medium text-gray-900 whitespace-nowrap dark:text-white">
                                            {student.adm_no}
                                        </th>
                                        <td className="px-6 py-4">
                                            {student.CA}
                                        </td>
                                        <td className="px-6 py-4">
                                            {student.exam}
                                        </td>
                                        <td className="px-6 py-4">
                                            {student.grade}
                                        </td>
                                        <td className="px-6 py-4">
                                            {student.unit}
                                        </td>
                                        {/* <td className="px-6 py-4">
                                            <div type="button" data-modal-target="editUserModal" data-modal-show="editUserModal" className="font-medium text-blue-600 dark:text-blue-500 hover:underline">View</div>
                                        </td> */}
                                    </tr>
                                );
                            })}
                        </tbody>
                    </table>
                </div>
            )}

            {showModal && <UploadResultForm hideModal={hideModal} sessions={sessions} stream={stream} course_id={course_id} />}
        </div>
    )
}

export default Result