'use client'

import AssignForm from "@/app/forms/AssignForm";
import { assignStaff } from "@/app/utils/app";
import { useState } from "react";
import swal from 'sweetalert2';
import cookies from "js-cookie";
import { notify } from "@/app/utils/helper";
import { useRouter } from "next/navigation";

const CTA = ({ stream, course_id }) => {
    const [isDropdownOpen, setDropdownOpen] = useState(false);
    const [showAssignFrom, setShowAssignForm] = useState(false);
    const router = useRouter();

    const toggleDropdown = () => setDropdownOpen(!isDropdownOpen);
    const toggleAssignForm = () => setShowAssignForm(!showAssignFrom);

    return (
        <div>
            <div className="relative flex justify-end">
                <button id="dropdownButton" data-dropdown-toggle="dropdown" className="bg-white inline-block text-gray-500 dark:text-gray-400 hover:bg-gray-100 dark:hover:bg-gray-700 focus:ring-4 focus:outline-none focus:ring-gray-200 dark:focus:ring-gray-700 rounded-lg text-sm p-1.5" type="button" onClick={toggleDropdown}>
                    <span className="sr-only">Open dropdown</span>
                    <svg className="w-5 h-5" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 16 3">
                        <path d="M2 0a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3Zm6.041 0a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3ZM14 0a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3Z" />
                    </svg>
                </button>
                {/* <!-- Dropdown menu --> */}
                {isDropdownOpen && (
                    <div id="dropdown" className="absolute top-6 right-4 z-10 text-base list-none bg-white divide-y divide-gray-100 rounded-lg shadow w-44 dark:bg-gray-700">
                        <ul className="py-2" aria-labelledby="dropdownButton">
                            <li>
                                <div className="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100 dark:hover:bg-gray-600 dark:text-gray-200 dark:hover:text-white" onClick={() => setShowAssignForm(true)}>Assign staff</div>
                            </li>
                            <li>
                                <div className="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100 dark:hover:bg-gray-600 dark:text-gray-200 dark:hover:text-white" onClick={() => setShowAssignForm(true)}>Edit</div>
                            </li>
                            <li>
                                <div className="block px-4 py-2 text-sm text-red-600 hover:bg-gray-100 dark:hover:bg-gray-600 dark:text-gray-200 dark:hover:text-white" >Delete</div>
                            </li>
                        </ul>
                    </div>
                )}
            </div>

            {showAssignFrom && <AssignForm onClose={toggleAssignForm} stream={stream} course_id={course_id} />}
        </div>
    )
}

export default CTA