'use client'

import RecommendationForm from "@/app/forms/RecommendationForm";
import { reviewApplication } from "@/app/utils/app";
import { useState } from "react";
import swal from 'sweetalert2';
import cookies from "js-cookie";
import { notify } from "@/app/utils/helper";
import { useRouter } from "next/navigation";

const CTA = ({ stream, id }) => {
    const [isDropdownOpen, setDropdownOpen] = useState(false);
    const [showRecommendationFrom, setShowRecommendationForm] = useState(false);
    const router = useRouter();

    const toggleDropdown = () => setDropdownOpen(!isDropdownOpen);
    const toggleRecommendationForm = () => setShowRecommendationForm(!showRecommendationFrom);

    const handleApproveDisapprove = async (data) => {
        try {
            swal.fire({
                title: "Are you sure?",
                text: "You won't be able to revert this!",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#ff8800",
                cancelButtonColor: "#d33",
                confirmButtonText: "Yes, I'm willing to go ahead!"
            }).then(async (result) => {
                if (result.isConfirmed) {
                    const response = await reviewApplication(cookies.get('admin'), stream, +id, data);
                    
                    if (!response) throw new Error('Review failed');

                    await swal.fire({
                        title: "Reviewed!",
                        text: `The applicant had been ${data.status}`,
                        icon: "success"
                    });

                    router.back();
                }
            });
        } catch (error) {
            console.log(error)
            if (error.response?.data?.errors) return notify('error', error.response.data.message)
            notify('error', error.message);
        }
    }

    return (
        <div>
            <div className="relative flex justify-end px-4">
                <button id="dropdownButton" data-dropdown-toggle="dropdown" className="inline-block text-gray-500 dark:text-gray-400 hover:bg-gray-100 dark:hover:bg-gray-700 focus:ring-4 focus:outline-none focus:ring-gray-200 dark:focus:ring-gray-700 rounded-lg text-sm p-1.5" type="button" onClick={toggleDropdown}>
                    <span className="sr-only">Open dropdown</span>
                    <svg className="w-5 h-5" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 16 3">
                        <path d="M2 0a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3Zm6.041 0a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3ZM14 0a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3Z" />
                    </svg>
                </button>
                {/* <!-- Dropdown menu --> */}
                {isDropdownOpen && (
                    <div id="dropdown" className="absolute top-6 right-4 z-10 text-base list-none bg-white divide-y divide-gray-100 rounded-lg shadow w-44 dark:bg-gray-700">
                        <ul className="py-2" aria-labelledby="dropdownButton">
                            <li>
                                <div className="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100 dark:hover:bg-gray-600 dark:text-gray-200 dark:hover:text-white" onClick={() => handleApproveDisapprove({ status: 'accepted', comment: 'Congratulations' })}>Approve</div>
                            </li>
                            <li>
                                <div className="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100 dark:hover:bg-gray-600 dark:text-gray-200 dark:hover:text-white" onClick={() => setShowRecommendationForm(true)}>Recommend</div>
                            </li>
                            <li>
                                <div className="block px-4 py-2 text-sm text-red-600 hover:bg-gray-100 dark:hover:bg-gray-600 dark:text-gray-200 dark:hover:text-white" onClick={() => handleApproveDisapprove({ status: 'rejected', comment: 'Sorry' })}>Dissaprove</div>
                            </li>
                        </ul>
                    </div>
                )}
            </div>

            {showRecommendationFrom && <RecommendationForm onClose={toggleRecommendationForm} />}
        </div>
    )
}

export default CTA